<?php

namespace Drupal\erasmus_subject_area_code;

/**
 * Defines an interface for an Erasmus Subject Area codes provider service.
 */
interface ErasmusSubjectAreaCodeManagerInterface {

  /**
   * Provides an array of allowed values for validation.
   *
   * @return array
   *   List of allowed Erasmus Subject Area codes.
   */
  public static function getAllowedValues(): array;

  /**
   * Provides an array of select options to be used in form elements.
   *
   * @param bool $prefix
   *   Whether the option labels should be prefixed with their respective keys.
   *
   * @return array
   *   Flat or nested array of select options with keys and option labels.
   */
  public function getSelectOptions(bool $prefix = TRUE): array;

}
