<?php

namespace Drupal\erasmus_subject_area_code\Plugin\Field\FieldWidget;

use Drupal\Core\Field\Attribute\FieldWidget;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\erasmus_subject_area_code\ErasmusSubjectAreaCodeManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Plugin implementation of the 'erasmus_subject_area_code_default' widget.
 */
#[FieldWidget(
  id: 'erasmus_subject_area_code_default',
  label: new TranslatableMarkup('Select list'),
  field_types: ['erasmus_subject_area_code'],
)]
class ErasmusSubjectAreaCodeDefaultWidget extends WidgetBase {

  /**
   * Erasmus Subject Area code manager.
   *
   * @var \Drupal\erasmus_subject_area_code\ErasmusSubjectAreaCodeManagerInterface
   */
  protected $codeManager;

  /**
   * {@inheritdoc}
   */
  public function __construct(
    $plugin_id,
    $plugin_definition,
    FieldDefinitionInterface $field_definition,
    array $settings,
    array $third_party_settings,
    ErasmusSubjectAreaCodeManagerInterface $code_manager,
  ) {
    parent::__construct($plugin_id, $plugin_definition, $field_definition, $settings, $third_party_settings);
    $this->codeManager = $code_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $plugin_id,
      $plugin_definition,
      $configuration['field_definition'],
      $configuration['settings'],
      $configuration['third_party_settings'],
      $container->get('erasmus_subject_area_code.manager')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $element['value'] = $element + [
      '#type' => 'select',
      '#options' => $this->codeManager->getSelectOptions(),
      '#empty_value' => '',
      '#default_value' => $items[$delta]->value ?? NULL,
      '#description' => $this->t('Select the Erasmus Subject Area code'),
    ];

    return $element;
  }

}
